/*****************************************************
This program was produced by the
CodeWizardAVR V2.05.0 Professional
Automatic Program Generator
 Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
http://www.hpinfotech.com

Project : 
Version : 
Date    : 20.09.2021
Author  : 
Company : 
Comments: 


Chip type               : ATmega8
Program type            : Application
AVR Core Clock frequency: 4,000000 MHz
Memory model            : Small
External RAM size       : 0
Data Stack size         : 256
*****************************************************/

#include <mega8.h>

// 1 Wire Bus interface functions
#include <1wire.h>

// DS1820 Temperature Sensor functions
#include <ds1820.h>
#include <ds18b20.h>
#include <stdio.h> //   10%
// maximum number of DS1820 devices
// connected to the 1 Wire bus
#define MAX_DS1820 8
// number of DS1820 devices
// connected to the 1 Wire bus
//unsigned char ds1820_devices;
// DS1820 devices ROM code storage area,
// 9 bytes are used for each device
// (see the w1_search function description in the help)
unsigned char rom_code[MAX_DS1820][9];

// Alphanumeric LCD Module functions
#include <alcd.h>
#include <delay.h>
// Declare your global variables here
volatile unsigned char lcd_buf[16];//, //lcd_buf1[16];
// Declare your global variables here

volatile int temp;
 unsigned char i,j,devices;
 
void main(void)
{    
// Declare your local variables here

// Input/Output Ports initialization
// Port B initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTB=0x00;
DDRB=0x00;

// Port C initialization
// Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTC=0x00;
DDRC=0x00;

// Port D initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTD=0x00;
DDRD=0x00;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: Timer 0 Stopped
TCCR0=0x00;
TCNT0=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer1 Stopped
// Mode: Normal top=0xFFFF
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer2 Stopped
// Mode: Normal top=0xFF
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
MCUCR=0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x00;

// USART initialization
// USART disabled
UCSRB=0x00;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

// ADC initialization
// ADC disabled
ADCSRA=0x00;

// SPI initialization
// SPI disabled
SPCR=0x00;

// TWI initialization
// TWI disabled
TWCR=0x00;

// 1 Wire Bus initialization
// 1 Wire Data port: PORTC
// 1 Wire Data bit: 0
// Note: 1 Wire port settings must be specified in the
// Project|Configure|C Compiler|Libraries|1 Wire IDE menu.
w1_init();

// Determine the number of DS1820 devices
// connected to the 1 Wire bus
devices=w1_search(0xf0,rom_code);

// Alphanumeric LCD initialization
// Connections specified in the
// Project|Configure|C Compiler|Libraries|Alphanumeric LCD menu:
// RS - PORTD Bit 0
// RD - PORTD Bit 1
// EN - PORTD Bit 2
// D4 - PORTD Bit 4
// D5 - PORTD Bit 5
// D6 - PORTD Bit 6
// D7 - PORTD Bit 7
// Characters/line: 8

for (i=0;i<devices;i++)
    {
    ds18b20_init(&rom_code[i][0],25,35,DS18B20_12BIT_RES);
    };
    
lcd_init(16);
sprintf(lcd_buf,"%u DS1820\nDevice detected",devices);
lcd_puts(lcd_buf);
delay_ms(2000);
w1_init(); 
if (devices)
{
for (i=0;i<devices;i++)
   {
   sprintf(lcd_buf,"Device #%u ROM\nCode is:",i+1);
   lcd_clear();
   lcd_puts(lcd_buf);
   delay_ms(2000);
   lcd_clear();
   for (j=0;j<8;j++)
       {
       sprintf(lcd_buf,"%02X ",rom_code[i][j]);
       lcd_puts(lcd_buf);
       if (j==3) lcd_gotoxy(0,1);
       };
   delay_ms(5000);
   };
}
else
while (1); /* stop here if no devices were found */
#asm("cli")
while (1)
  {         
            for (i=0;i<devices;i++)
          {
      temp=ds18b20_temperature(&rom_code[i][0]);
      
          j='+';
          if (temp<0)
             {
             j='-';
             temp=-temp;
             };
         sprintf(lcd_buf,"t%u=%c%i.%u\xdf" "C",(i+1),j,temp/10,temp%10);
      lcd_clear();
      lcd_puts(lcd_buf);
      delay_ms(800);
          };
  };

      }
