/*****************************************************
Project : Solar Charge Controller M88
Version : 1.0
Date    : 26.06.2015
Author  : Sergey                          
Company : Intellekt Dialog                

Chip type           : ATmega88
Clock frequency     : 8,000000 MHz
*****************************************************/

#include <mega88.h>
#include <stdint.h>
#include "flex_lcd.h"
#include <delay.h>

//-----------------------------------------------------------
//
//-----------------------------------------------------------
#define TR_CH1_ON()		PORTD.0=1 // transformer channels
#define TR_CH2_ON()		PORTD.1=1	
#define TR_CH1_OFF()	PORTD.0=0
#define TR_CH2_OFF()	PORTD.1=0

#define WDR()	#asm("wdr")

//-----------------------------------------------------------
// PSU impulse transformer wave generation
// dead-time
//-----------------------------------------------------------
interrupt [TIM2_COMPA] void timer2_compa_isr(void)
{
	TR_CH1_OFF();
	TR_CH2_OFF();
}

//-----------------------------------------------------------
// PSU impulse transformer
// set channel
//-----------------------------------------------------------
interrupt [TIM2_COMPB] void timer2_compb_isr(void)
{
	static uint8_t active_channel = 0;
	
	if( active_channel == 0 )
	{
		TR_CH1_ON();
	}else
	{ 
		TR_CH2_ON();
	};
	
	active_channel = ~active_channel; // set next channel
}

void test_select( void )
{
	lcd_clear();
	lcd_gotoxy(0,0);
	lcd_putsf("SELECTED ITEM");
}

//  

#define NULL	0
#define FALSE	0
#define TRUE	(!FALSE)

typedef flash struct mnuItem{
	flash struct mnuItem *Next;
	flash struct mnuItem *Prev;
	flash struct mnuItem *Parent;
	flash struct mnuItem *Child;
	void (*SelectCallback)(void);
	void (*EnterCallback)(void);
	flash char *Text;
} mnuItem_t; 

#define DECLARE_ITEM( Name )	extern flash mnuItem_t Name
#define MAKE_ITEM			flash mnuItem_t


DECLARE_ITEM( main1 ); //     
DECLARE_ITEM( main2 );
DECLARE_ITEM( main3 );
DECLARE_ITEM( main4 );
DECLARE_ITEM( child31 );
DECLARE_ITEM( child32 );
DECLARE_ITEM( child33 );
DECLARE_ITEM( child311 );
DECLARE_ITEM( child312 );

//   
//                Next,        Prev,     Parent, Child,    Select, Enter, Text
MAKE_ITEM main1={ &main2,      NULL,     NULL,   NULL,&test_select,NULL, "M1 >" };
MAKE_ITEM main2={ &main3,      &main1,   NULL,   NULL,     NULL,   NULL, "M2" };
MAKE_ITEM main3={ &main4,      &main2,   NULL,   &child31, NULL,   NULL, "M3 .."};
MAKE_ITEM main4={ NULL,        &main3,   NULL,   NULL,     NULL,   NULL, "M4"};

MAKE_ITEM child31={&child32,   &child33, &main3, &child311,NULL,   NULL, "M3/CHILD1 ."};
MAKE_ITEM child32={&child33,   &child31, &main3, NULL,     NULL,   NULL, "M3/CHILD2"};
MAKE_ITEM child33={&child31,   &child32, &main3, NULL,     NULL,   NULL, "M3/CHILD3"};

MAKE_ITEM child311={&child312, &child312,&child31, NULL,&test_select,NULL, "M3/CHILD1/CH1 >"};
MAKE_ITEM child312={&child311, &child311,&child31, NULL,   NULL,   NULL, "M3/CHILD1/CH2"};

MAKE_ITEM *CurrentItem; //  
uint8_t isItemSelected; //     

void initMenu( void )   //  
{
	CurrentItem = &main1;
	isItemSelected = FALSE;
	lcd_clear();
	lcd_gotoxy(0,0);
	lcd_putsf( CurrentItem->Text );	
}

typedef enum{  //       
	NO_BTN=0,
	BTN_UP,
	BTN_DOWN,
	BTN_LEFT,
	BTN_RIGHT	
} btnStatus;

uint8_t mnuItemSelect( void ) //  ,    -
{
	if( CurrentItem->SelectCallback != NULL )
	{ 
		isItemSelected = TRUE;
		((void(*)(void))CurrentItem->SelectCallback)();
		return TRUE;	
	};               
	
	return FALSE;
}

void navigateMenu( btnStatus btn ) // 
{
	switch( btn )
	{ 
		case NO_BTN:
			return;
			break;
		case BTN_UP:
			if( isItemSelected != FALSE )
			{    // selected - do not change item
				return;
			};
			if( CurrentItem->Prev != NULL )
			{
				CurrentItem = CurrentItem->Prev;           
			};
			break;
		case BTN_DOWN:
			if( isItemSelected != FALSE )
			{ 
				return;
			};
			if( CurrentItem->Next != NULL )
			{
				CurrentItem = CurrentItem->Next;
			};
			break;
		case BTN_LEFT: 
			if( isItemSelected != FALSE )
			{    // if selected - return to menu
				isItemSelected = FALSE;
			}else if( CurrentItem->Parent != NULL )
			{
				CurrentItem = CurrentItem->Parent;
			};
			break;
		case BTN_RIGHT: // enter
			if( isItemSelected != FALSE )
			{ 
				return;
			};
			if( CurrentItem->Child != 0 )
			{
				CurrentItem = CurrentItem->Child;
			}else // no child, possibly you can enter/select
			if( mnuItemSelect() != FALSE )
			{ 
				return;
			};
			break;
	};
	lcd_clear();
	lcd_gotoxy(0,0);
	lcd_putsf( CurrentItem->Text );	
}

//-----------------------------------------------------------
// Main App
//-----------------------------------------------------------
void main(void)
{
// Declare your local variables here

// Crystal Oscillator division factor: 1
#pragma optsize-
CLKPR=0x80;
CLKPR=0x00;
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif

// Input/Output Ports initialization
// Port B initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTB=0x00;
DDRB=0x00;

// Port C initialization
// Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTC=0x00;
DDRC=0x00;

// Port D initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTD=0x00;
DDRD=0x00;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: Timer 0 Stopped
// Mode: Normal top=FFh
// OC0A output: Disconnected
// OC0B output: Disconnected
TCCR0A=0x00;
TCCR0B=0x00;
TCNT0=0x00;
OCR0A=0x00;
OCR0B=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer 1 Stopped
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer 1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: 8000,000 kHz
// Mode: Fast PWM top=OCR2A
// OC2A output: Disconnected
// OC2B output: Disconnected
ASSR=0x00;
//TCCR2A=0x03;
//TCCR2B=0x09;
TCNT2=0x00;
OCR2A=0xFF;
OCR2B=0x12;

// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
// Interrupt on any change on pins PCINT0-7: Off
// Interrupt on any change on pins PCINT8-14: Off
// Interrupt on any change on pins PCINT16-23: Off
EICRA=0x00;
EIMSK=0x00;
PCICR=0x00;

// Timer/Counter 0 Interrupt(s) initialization
TIMSK0=0x00;
// Timer/Counter 1 Interrupt(s) initialization
TIMSK1=0x00;
// Timer/Counter 2 Interrupt(s) initialization
TIMSK2=0x06;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
ADCSRB=0x00;

// Watchdog Timer initialization
// Watchdog Timer Prescaler: OSC/1024k
// Watchdog Timer interrupt: Off
#pragma optsize-
#asm("wdr")
WDTCSR=0x39;
WDTCSR=0x29;
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif

// Global enable interrupts
#asm("sei")

lcd_init();
//lcd_putsf("Hello world!");

initMenu();

while (1)
      {
      WDR();
      if( PIND.2 == 0 )
      { 
      	navigateMenu( BTN_UP );
      	delay_ms( 500 );
      };             
      
      if( PIND.3 == 0 )
      { 
      	navigateMenu( BTN_DOWN );
      	delay_ms( 500 );
      };
      
      if( PIND.4 == 0 )
      { 
      	navigateMenu( BTN_LEFT );
      	delay_ms( 500 );
      };                   
      
      if( PIND.5 == 0 )
      { 
      	navigateMenu( BTN_RIGHT );
      	delay_ms( 500 ); 
      };

      };
}
