//-----------------------------------------------------------
// 8 bit KS066 LCD driver
//-----------------------------------------------------------


/// LCD ports configuration ///
/// Output pins definitions ///
#define RS 		PORTD.6
//#define 		RW PORTD.6
#define E  		PORTD.7
#define DATA_PORT	PORTB

/// Data directions ///
#define RS_DR 		DDRD.6
//#define 		RW_DR DDRD.6
#define E_DR  		DDRD.7
#define DATA_DIR	DDRB
///////////////////////

#define BIT_N	3 // display on-off
#define BIT_F	2 // xLine mode
#define BIT_B	0 // blink
#define BIT_C	1 // cursor
#define BIT_D	2 // display of-off
#define BIT_SH	0 // entire shift
#define BIT_ID	1 // increment/decrement

#define FALSE	0
#define TRUE	(!FALSE)

//numeric output parameters 
#define SPACE_ALLOW     TRUE  //do not supress spaces
#define SPACE_SUPRESS   FALSE //supress spaces in numeric output

/// LCD parameters ///
#define lcd_max_x 16//number of chars in one row
#define lcd_max_y 4 //number of rows
//////////////////////


//#if LCD_LANG==LCD_RUS
// win1251 - LCD translation table ///////////
const unsigned char TransTable[] =
{0x41,0xA0,0x42,0xA1,0xE0,0x45,0xA3,0xA4,				//C0-C7		,,,,,,,
0xA5,0xA6,0x4B,0xA7,0x4D,0x48,0x4F,0xA8,				//C8-CF		,,,,,,,
0x50,0x43,0x54,0xA9,0xAA,0x58,0xE1,0xAB,				//D0-D7		,,,,,,,
0xAC,0xE2,0xAD,0xAE,0x62,0xAF,0xB0,0xB1,				//D8-DF		,,,,,,,
0x61,0xB2,0xB3,0xB4,0xE3,0x65,0xB6,0xB7,				//E0-E7		,,,,,,,
0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0x6F,0xBE,				//E8-EF		,,,,,,,
0x70,0x63,0xBF,0x79,0xE4,0x78,0xE5,0xC0,				//F0-F7		,,,,,,,
0xC1,0xE6,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7};				//F8-FF		,,,,,,,
///////////////////////////////////////////////
/*#else
const unsigned char TransTable[] =
{'A','B','V','G','D','E','J','Z',				//C0-C7		?,?,?,?,?,?,?,?
'I','Y','K','L','M','N','O','P',				//C8-CF		?,?,?,?,?,?,?,?
'R','S','T','U','F','H','C','C',				//D0-D7		?,?,?,?,?,?,?,?
'S','S',0xAD,'I',0x62,'E','U','A',				//D8-DF		?,?,?,?,?,?,?,?
'a','b','v','g','d','e','j','z',				//E0-E7		?,?,?,?,?,?,?,?
'i','y','k','l','m','n','o','p',				//E8-EF		?,?,?,?,?,?,?,?
'r','s','t','u','f','h','c','c',				//F0-F7		?,?,?,?,?,?,?,?
's','s',0xC2,'i',0xC4,'e','u','a'};
#endif*/

void lcd_init(void);
void lcd_write_cmd(char cmd);
void lcd_write_data(char data);
void lcd_clear(void);
void lcd_gotoxy(unsigned char x, unsigned char y);
void lcd_send_data(char dta);
//void define_char(flash char *pc,unsigned char char_code);

#include <delay.h>

unsigned char lcd_x_cnt=0;
unsigned char lcd_y_cnt=0;
static unsigned char _base_y[4]={0x80, 0xC0, 0x80+lcd_max_x, 0xC0+lcd_max_x}; /*HD44780 or KS0066 controller map*/

void lcd_init(void)
{
E=0;
//RW=0;
RS=0;
DATA_PORT = 0;


E_DR=1;//set outputs
//RW_DR=1;
RS_DR=1;
DATA_DIR = 0xFF;

delay_ms(100);//wait for LCD internal initialization

lcd_write_cmd( 0x30 | 0x08 ); // function set
delay_us( 50 );

lcd_write_cmd( 0x08 ); // on-off
delay_us( 50 );

lcd_write_cmd( 0x01 ); // display clear
delay_ms( 2 );

lcd_write_cmd( (1<<2)|(1<<BIT_ID)|(0<<BIT_SH) );
delay_us( 50 );

lcd_clear();
}

/// Clear LCD ///
void lcd_clear(void)
{
        lcd_write_cmd(0x02); // return Home
        delay_ms(2);
        lcd_write_cmd(0x0C); // disp on-off contr
        delay_us(50);
        lcd_write_cmd(0x01); // clear disp
        delay_ms(2);
        lcd_gotoxy(0,0);
}

/// Print single char ///
void lcd_putchar(char chr)
{
if (chr==0xA8) chr=0xA2;							//
if (chr==0xB8) chr=0xB5;							//
if (chr > 0xBF) chr = TransTable [(chr-0xC0)];		//  
lcd_write_data(chr);
if(++lcd_x_cnt==lcd_max_x)
        {
        lcd_x_cnt=0;
        if(++lcd_y_cnt==lcd_max_y) lcd_y_cnt=0;
        lcd_gotoxy(0,lcd_y_cnt);
        }
}

/* print integer: value, number of leading zeroes */
void lcd_print_int
(unsigned int num, unsigned char lead_zero, unsigned char use_space)
{
        unsigned int temp;
        unsigned char c[5],i;
        
        temp=num;
        
        for(i=0;i<5;i++)
                c[i]='0';
        
        while(num>=10000){num-=10000; ++c[4];};
        while(num>=1000) {num-=1000;  ++c[3];};
        while(num>=100)  {num-=100;   ++c[2];};
        while(num>=10)   {num-=10;    ++c[1];};
        while(num)       {--num;      ++c[0];};
        
        if((temp>=10000)||(lead_zero>4)) lcd_putchar(c[4]);
        else    if(use_space==SPACE_ALLOW) lcd_putchar(' ');
        
        if((temp>=1000)||(lead_zero>3))  lcd_putchar(c[3]);
        else    if(use_space==SPACE_ALLOW) lcd_putchar(' ');
        
        if((temp>=100)||(lead_zero>2))   lcd_putchar(c[2]);
        else    if(use_space==SPACE_ALLOW) lcd_putchar(' ');
        
        if((temp>=10)||(lead_zero>1))    lcd_putchar(c[1]);
        else    if(use_space==SPACE_ALLOW) lcd_putchar(' ');
        
        lcd_putchar(c[0]);
}

/// Set cursor position x y ///
void lcd_gotoxy(unsigned char x, unsigned char y)
{
        lcd_write_cmd(_base_y[y]+x);
        lcd_x_cnt=x;
        lcd_y_cnt=y;
        delay_us(50);
}

// write the string str located in SRAM to the LCD
void lcd_puts(char *str)
{
char k;
while (k=*str++) lcd_putchar(k);
}

// write the string str located in FLASH to the LCD
void lcd_putsf(char flash *str)
{
char k;
while (k=*str++) lcd_putchar(k);
}


/// Send to command register ///
void lcd_write_cmd(char cmd)
{
RS=0;//command mode
lcd_send_data(cmd);
}

/// Send to data register ///
void lcd_write_data(char data)
{
RS=1;//data mode
lcd_send_data(data);
delay_us(50);
}

/// Send prepared data ///
void lcd_send_data(char dta)
{
E=0;
//RW=0;//write mode

delay_us(1);

DATA_PORT = dta;
E=1;//latch-up
delay_us(1);
E=0;
delay_us(1);
}


/* function used to define user characters */
/// You should execute lcd_gotoxy() command ///
/// after defining all your chars           ///
/*void define_char(flash unsigned char *pc, unsigned char char_code)
{
unsigned char i,a;
a=(char_code<<3) | 0x40;
for (i=0; i<8; i++)
        {
        //RS=1;
        lcd_write_command(a++);
        lcd_write_data(*pc++);
        };
}*/

